using System;
using CsGL.OpenGL;

namespace SPStudio
{
	/// <summary>
	/// Contains 8 Vector3Ds.
	/// It knows its validity
	/// with respect to the
	/// 4 regions.
	/// Knows how to draw itself
	/// in OpenGL.
	/// </summary>
	public class Voxel: Renderable
	{
		#region Public Vars
		public Vector3D p1;
		public Vector3D p2;
		public Vector3D p3;
		public Vector3D p4;
		public Vector3D p5;
		public Vector3D p6;
		public Vector3D p7;
		public Vector3D p8;
		#endregion

		#region Constructors
		/// <summary>
		/// Initialize the 8 points
		/// of the voxel using
		/// the Vector3D's default
		/// constructor.
		/// </summary>
		public Voxel()
		{
			p1 = new Vector3D();
			p2 = new Vector3D();
			p3 = new Vector3D();
			p4 = new Vector3D();
			p5 = new Vector3D();
			p6 = new Vector3D();
			p7 = new Vector3D();
			p8 = new Vector3D();
		}

		/// <summary>
		/// Initialize the 8 points
		/// of the voxel to
		/// reference the 8 Vector3Ds
		/// passed in.
		/// </summary>
		/// <param name="P1"></param>
		/// <param name="P2"></param>
		/// <param name="P3"></param>
		/// <param name="P4"></param>
		/// <param name="P5"></param>
		/// <param name="P6"></param>
		/// <param name="P7"></param>
		/// <param name="P8"></param>
		public Voxel(Vector3D P1, Vector3D P2, Vector3D P3, Vector3D P4, Vector3D P5, Vector3D P6, Vector3D P7, Vector3D P8)
		{
			p1 = P1;
			p2 = P2;
			p3 = P3;
			p4 = P4;
			p5 = P5;
			p6 = P6;
			p7 = P7;
			p8 = P8;
		}

		/// <summary>
		/// Copy constructor.
		/// </summary>
		/// <param name="V"></param>
		public Voxel(Voxel V)
		{
			p1 = new Vector3D(V.p1);
			p2 = new Vector3D(V.p2);
			p3 = new Vector3D(V.p3);
			p4 = new Vector3D(V.p4);
			p5 = new Vector3D(V.p5);
			p6 = new Vector3D(V.p6);
			p7 = new Vector3D(V.p7);
			p8 = new Vector3D(V.p8);
		}
		#endregion

		#region Regional Inclusion Tests
		public bool inAll()
		{
			return (in0to90()&&in90to180()&&in180to270()&&in270to360());
		}

		public bool inAny()
		{
			return (in0to90()||in90to180()||in180to270()||in270to360());
		}

		public bool in0to90()
		{
			return (p1.in0to90||p2.in0to90||p3.in0to90||p4.in0to90||p5.in0to90||p6.in0to90||p7.in0to90||p8.in0to90);
		}

		public bool in90to180()
		{
			return (p1.in90to180||p2.in90to180||p3.in90to180||p4.in90to180||p5.in90to180||p6.in90to180||p7.in90to180||p8.in90to180);
		}

		public bool in180to270()
		{
			return (p1.in180to270||p2.in180to270||p3.in180to270||p4.in180to270||p5.in180to270||p6.in180to270||p7.in180to270||p8.in180to270);
		}

		public bool in270to360()
		{
			return (p1.in270to360||p2.in270to360||p3.in270to360||p4.in270to360||p5.in270to360||p6.in270to360||p7.in270to360||p8.in270to360);
		}
		#endregion

		#region Renderable Members	
		/// <summary>
		/// Uses CsGL.OpenGL functionality
		/// in order to render the object.
		/// </summary>
		/// <param name="State"></param>
		public void OpenGLDraw(bool[] State)
		{
			//State is expected to be a bool[8]
			if(State[4]&&State[5]&&State[6]&&State[7]&&inAll())
			{
				renderSolid();
			}
			else if(State[4]&&!State[5]&&!State[6]&&!State[7]&&in0to90())
			{
				renderSolid();
			}
			else if(!State[4]&&State[5]&&!State[6]&&!State[7]&&in90to180())
			{
				renderSolid();
			}
			else if(!State[4]&&!State[5]&&State[6]&&!State[7]&&in180to270())
			{
				renderSolid();
			}
			else if(!State[4]&&!State[5]&&!State[6]&&State[7]&&in270to360())
			{
				renderSolid();
			}
			else if(!State[4]&&!State[5]&&State[6]&&State[7]&&in180to270()&&in270to360())
			{
				renderSolid();
			}
			else if(!State[4]&&State[5]&&!State[6]&&State[7]&&in90to180()&&in270to360())
			{
				renderSolid();
			}
			else if(!State[4]&&State[5]&&State[6]&&!State[7]&&in90to180()&&in180to270())
			{
				renderSolid();
			}
			else if(!State[4]&&State[5]&&State[6]&&State[7]&&in90to180()&&in180to270()&&in270to360())
			{
				renderSolid();
			}
			else if(State[4]&&!State[5]&&!State[6]&&State[7]&&in0to90()&&in270to360())
			{
				renderSolid();
			}
			else if(State[4]&&!State[5]&&State[6]&&!State[7]&&in0to90()&&in180to270())
			{
				renderSolid();
			}
			else if(State[4]&&!State[5]&&State[6]&&State[7]&&in0to90()&&in180to270()&&in270to360())
			{
				renderSolid();
			}
			else if(State[4]&&State[5]&&!State[6]&&!State[7]&&in0to90()&&in90to180())
			{
				renderSolid();
			}
			else if(State[4]&&State[5]&&!State[6]&&State[7]&&in0to90()&&in90to180()&&in270to360())
			{
				renderSolid();
			}
			else if(State[4]&&State[5]&&State[6]&&!State[7]&&in0to90()&&in90to180()&&in180to270())
			{
				renderSolid();
			}			
			else if(inAny())
			{
				if(State[0]&&in0to90())
					renderTransparent(0);
				if(State[1]&&in90to180())
					renderTransparent(1);
				if(State[2]&&in180to270())
					renderTransparent(2);
				if(State[3]&&in270to360())
					renderTransparent(3);
			}
		}

		#endregion

		#region Render Solid and Render Transparent
		private void renderSolid()
		{
			GL.glBegin(GL.GL_QUADS);
			GL.glColor3d(1.0,0.0,0.0);

			GL.glVertex3d(p8.x,p8.y,p8.z);
			GL.glVertex3d(p7.x,p7.y,p7.z);
			GL.glVertex3d(p6.x,p6.y,p6.z);
			GL.glVertex3d(p5.x,p5.y,p5.z);

			GL.glVertex3d(p4.x,p4.y,p4.z);
			GL.glVertex3d(p3.x,p3.y,p3.z);
			GL.glVertex3d(p2.x,p2.y,p2.z);
			GL.glVertex3d(p1.x,p1.y,p1.z);

			GL.glVertex3d(p8.x,p8.y,p8.z);
			GL.glVertex3d(p7.x,p7.y,p7.z);
			GL.glVertex3d(p3.x,p3.y,p3.z);
			GL.glVertex3d(p4.x,p4.y,p4.z);

			GL.glVertex3d(p5.x,p5.y,p5.z);
			GL.glVertex3d(p6.x,p6.y,p6.z);
			GL.glVertex3d(p2.x,p2.y,p2.z);
			GL.glVertex3d(p1.x,p1.y,p1.z);

			GL.glVertex3d(p4.x,p4.y,p4.z);
			GL.glVertex3d(p8.x,p8.y,p8.z);
			GL.glVertex3d(p5.x,p5.y,p5.z);
			GL.glVertex3d(p1.x,p1.y,p1.z);

			GL.glVertex3d(p3.x,p3.y,p3.z);
			GL.glVertex3d(p7.x,p7.y,p7.z);
			GL.glVertex3d(p6.x,p6.y,p6.z);
			GL.glVertex3d(p2.x,p2.y,p2.z);

			GL.glEnd();	
		}

		private void renderTransparent(int State)
		{		
			GL.glBegin(GL.GL_POINTS);
			if(State==0) GL.glColor4d(1.0,0.0,0.0,0.5);			
			if(State==1) GL.glColor4d(0.0,1.0,0.0,0.5);
			if(State==2) GL.glColor4d(1.0,1.0,1.0,0.5);
			if(State==3) GL.glColor4d(0.0,0.0,1.0,0.5);
			GL.glVertex3d(p8.x,p8.y,p8.z);
			GL.glVertex3d(p7.x,p7.y,p7.z);
			GL.glVertex3d(p6.x,p6.y,p6.z);
			GL.glVertex3d(p5.x,p5.y,p5.z);
			GL.glVertex3d(p4.x,p4.y,p4.z);
			GL.glVertex3d(p3.x,p3.y,p3.z);
			GL.glVertex3d(p2.x,p2.y,p2.z);
			GL.glVertex3d(p1.x,p1.y,p1.z);
			GL.glEnd();
		}
		#endregion
	}
}
